<?php
// Sāk jaunu vai atjauno esošo sesiju
session_start();

// Norāda servera datus
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda, vai ir veiksmīga savienošanās ar datubāzi
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Funkcija, lai iegūtu lietotāja ID no sesijas vai izveidotu jaunu, ja nav
function getUserId($conn) {
    if (isset($_SESSION['user_id'])) {
        return $_SESSION['user_id'];
    } else {
        $user_id = 1; // Ja nav pieejams lietotāja ID no sesijas, iestata noklusējuma vērtību
        $_SESSION['user_id'] = $user_id; // Saglabā jauno lietotāja ID sesijā
        return $user_id;
    }
}

// Iegūst lietotāja ID
$user_id = getUserId($conn);

// Iegūst kopsavilkuma informāciju
$sql = "SELECT SUM(score) AS total_score, COUNT(*) AS total_tests_completed FROM test_results WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$summary = $result->fetch_assoc(); // Iegūst kopsavilkuma datus
$stmt->close();

// Iegūst detalizētu testa informāciju
$sql = "SELECT t.name AS test_name, r.score AS test_score 
        FROM test_results r
        JOIN tests t ON r.test_id = t.id
        WHERE r.user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$tests = [];
while ($row = $result->fetch_assoc()) {
    $tests[] = $row; // Pievieno katru testa rezultātu masīvam
}

// Sagatavo atbildes masīvu
$response = [
    'summary' => $summary, // Kopsavilkuma informācija
    'tests' => $tests // Detalizēta testu informācija
];

// Izvada atbildi kā JSON
echo json_encode($response);

$stmt->close();
$conn->close();
?>
